$driver_file = $args[0];

$cert = (Get-AuthenticodeSignature $driver_file).SignerCertificate;
if (-not $cert) {
  $msg = "{0} is not signed, cannot extract certificate" -f $driver_file
	Write-Error $msg -ErrorAction Stop
}

$temp_file = New-TemporaryFile;
[System.IO.File]::WriteAllBytes($temp_file, $cert.Export([System.Security.Cryptography.X509Certificates.X509ContentType]::Cert));

$cert_store_list = "root","TrustedPublisher";
foreach ($store in $cert_store_list) {
  certutil -addstore $store $temp_file
}
