$driverFile = $args[0];
$tempFile = New-TemporaryFile;
$certStores = "root","TrustedPublisher";
$exportType = [System.Security.Cryptography.X509Certificates.X509ContentType]::Cert;

$cert = (Get-AuthenticodeSignature $driverFile).SignerCertificate;
if ($cert -eq $NULL) {
    $errorMsg = "{0} is not signed, cannot extract certificate" -f $driverFile
	Write-Error $errorMsg -ErrorAction Stop
}
[System.IO.File]::WriteAllBytes($tempFile, $cert.Export($exportType));

foreach ($store in $certStores)
{
  certutil -addstore $store $tempFile
}