﻿function RemoveAGSConfiguratorFolder() {
    if(($item = Get-Item -Path "C:\Windows\System32\A-Volute" -ErrorAction SilentlyContinue)) {
        Remove-Item $item -Recurse -ErrorAction SilentlyContinue
    }
}

function RemoveSoftwareComponent() {
    if (($item = Get-Service -Name *Audiosrv* -ErrorAction SilentlyContinue)) {
        Stop-Service $item
    }

    if (($item = Get-Item -Path "C:\Windows\System32\*nahimic*" -ErrorAction SilentlyContinue)) {
        Remove-Item $item -ErrorAction SilentlyContinue
    }

    if (($item = Get-Item -Path "C:\Windows\SysWOW64\*nahimic*" -ErrorAction SilentlyContinue)) {
        Remove-Item $item -ErrorAction SilentlyContinue
    }

    if (($item = Get-Service -Name *Audiosrv* -ErrorAction SilentlyContinue)) {
        Start-Service $item
    }
}

function RemoveModulesFolder() {
    if (($item = Get-Item -Path "C:\ProgramData\A-Volute" -ErrorAction SilentlyContinue)) {
        Remove-Item $item -Recurse -ErrorAction SilentlyContinue
    }
}

function RemoveNahimicService() {
    if (($item = Get-Service -DisplayName *Nahimic* -ErrorAction SilentlyContinue)) {
        Stop-Service $item
        sc.exe delete "NahimicService"
        Set-ItemProperty -Path HKCU:\SOFTWARE\Microsoft\Windows\CurrentVersion\RunOnce -Name "!NahimicCleanup" -Value "C:\Windows\System32\cmd.exe /c $($PSScriptRoot)\..\RemoveAll.bat"
        Write-Host ""
        Write-Host "!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
        Write-Host "System reboot is required in order to remove product binaries and data properly."
        Write-Host "Please ensure to sign in to the same user account in order to have the script launch automatically and perform the cleanup."
        Write-Host "If the script isn't launched automatically after user sign in, please launch it manually."
        Write-Host "!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
        Restart-Computer -Confirm -Force
    }
}

function RemoveApplication() {
    Get-AppxPackage -Name A-Volute.Nahimic | Remove-AppxPackage
}

function RemoveRealtekDevices() {
    $devices = Get-PnpDevice -FriendlyName "*Realtek*" | Select FriendlyName,InstanceId
    ForEach($device in $devices) {
       & "$($PSScriptRoot)\devcon.exe" remove "@$($device.InstanceId)"
    }
}

function RestoreRealtekDevices() {
    & "$($PSScriptRoot)\devcon.exe" rescan
}

function GetAvoluteDrivers() {
    $drivers = pnputil.exe /enum-drivers | out-string
    $pattern = "(?m)"+
                "Published Name[\s:]*(?<pub>.*inf).*\n"+
                "Original Name[\s:]*(?<orig>.*inf).*\n"+
                "Provider Name[\s:]*.*A-Volute.*"
    $result = Select-String -InputObject $drivers -Pattern $pattern -AllMatches
    return $result.Matches
}

function RemoveAVoluteExtensions() {
    $drivers = GetAvoluteDrivers
    if (($drivers.Count -eq 0)) {
        return
    }
    RemoveRealtekDevices
    ForEach($driver in $drivers) {
        $inf = $driver.Groups["pub"].Value
        pnputil /delete-driver "$($inf)" /force
    }
    RestoreRealtekDevices
}

function RemoveRegistryKeys() {
    Remove-Item -Path HKLM:\SOFTWARE\Nahimic -Recurse -ErrorAction SilentlyContinue
    Remove-Item -Path HKLM:\SOFTWARE\A-Volute -Recurse -ErrorAction SilentlyContinue
    Remove-Item -Path HKCU:\SOFTWARE\AVolute -Recurse -ErrorAction SilentlyContinue
    Remove-Item -Path HKCU:\SOFTWARE\Nahimic -Recurse -ErrorAction SilentlyContinue
}

RemoveNahimicService
RemoveSoftwareComponent
RemoveModulesFolder
RemoveApplication
RemoveAGSConfiguratorFolder
RemoveAVoluteExtensions
RemoveRegistryKeys
pause